package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.FlowletBuilder;
import org.seasar.nazuna.NazunaTransAttribute;

public class RuleBuilderTest extends TestCase {

    public RuleBuilderTest(String name) {
        super(name);
    }
  
    public void testParse() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Hello.xml";
    	Flowlet flowlet = FlowletBuilder.parse(xmlFileName);
    	flowlet.execute();
    }
    
    public void testRequiredTransaction() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction.xml";
    	Flowlet flowlet = FlowletBuilder.parse(xmlFileName);
    	assertEquals("1", NazunaTransAttribute.REQUIRED, flowlet.getTransAttribute());
    }
    
    public void testRequiresNewTransaction() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction2.xml";
    	Flowlet flowlet = FlowletBuilder.parse(xmlFileName);
    	assertEquals("1", NazunaTransAttribute.REQUIRES_NEW, flowlet.getTransAttribute());
    }
    
    public void testMandatoryTransaction() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/Transaction3.xml";
    	Flowlet flowlet = FlowletBuilder.parse(xmlFileName);
    	assertEquals("1", NazunaTransAttribute.MANDATORY, flowlet.getTransAttribute());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(RuleBuilderTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{RuleBuilderTest.class.getName()});
    }
}