package test.org.seasar.sql;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;

import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.sql.ConnectionPoolMetaData;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.sql.XADataSourceImpl;
import org.seasar.transaction.XidImpl;

public class SQLXAResourceTest extends TestCase {

    private XAConnectionImpl _xaCon;
    private XAResource _xaRes;

    public SQLXAResourceTest(String name) {
        super(name);
    }

    public void testSpikeOracleXAResource() throws Exception {
        Properties p = new Properties();
        p.setProperty("URL", "jdbc:oracle:thin:@d1606:1521:ark");
        p.setProperty("user", "ark");
        p.setProperty("password", "ark");
        ConnectionPoolMetaData cpmd = new ConnectionPoolMetaData("oracle", "jdbc/oracle",
          "oracle.jdbc.xa.client.OracleXADataSource", 600, 2, p);
        XAConnection xaCon = cpmd.getXAConnection();
        XAConnection xaCon2 = cpmd.getXAConnection();
        Connection con = xaCon.getConnection();
        Connection con2 = xaCon2.getConnection();
        try {
            XAResource xaRes = xaCon.getXAResource();
            System.out.println("className=" + xaRes.getClass().getName());
            System.out.println("isSameRM=" + xaRes.isSameRM(xaRes));
            System.out.println("isSameRM2=" + xaRes.isSameRM(_xaRes));
            System.out.println("isSameRM3=" + xaRes.isSameRM(xaCon.getXAResource()));
            XAResource xaRes2 = xaCon2.getXAResource();
            System.out.println("isSameRM4=" + xaRes.isSameRM(xaRes2));
            Xid xid = new XidImpl();
            Xid xid2 = new XidImpl(xid, 1);
            xaRes.start(xid, XAResource.TMNOFLAGS);
            xaRes2.start(xid2, XAResource.TMNOFLAGS);
            Statement stmt = con.createStatement();
            stmt.execute("update emp set ename = ename where empno = 7788");
            stmt.execute("update dept set dname = dname where deptno = 20");
            stmt.close();
            Statement stmt2 = con2.createStatement();
            stmt2.execute("update dept set dname = dname where deptno = 10");
            stmt2.close();
            xaRes.end(xid, XAResource.TMSUCCESS);
            xaRes2.end(xid2, XAResource.TMSUCCESS);
            int vote = xaRes.prepare(xid);
            int vote2 = xaRes2.prepare(xid2);
            if (vote == XAResource.XA_OK) {
                xaRes.commit(xid, false);
            } else {
                System.out.println("vote:XA_RDONLY");
            }
            if (vote2 == XAResource.XA_OK) {
                xaRes2.commit(xid2, false);
            } else {
                System.out.println("vote2:XA_RDONLY");
            }
        } finally {
            xaCon.close();
            xaCon2.close();
        }
    }

    public void testDoBegin() throws Exception {
        assertTrue("1", _xaCon.getPhysicalConnection().getAutoCommit());
        Xid xid = new XidImpl();
        _xaRes.start(xid, XAResource.TMNOFLAGS);
        assertTrue("2", !_xaCon.getPhysicalConnection().getAutoCommit());
    }

    public void testDoPrepare() throws Exception {
        Xid xid = new XidImpl();
        _xaRes.start(xid, XAResource.TMNOFLAGS);
        _xaRes.end(xid, XAResource.TMSUCCESS);
        assertEquals("1", XAResource.XA_OK, _xaRes.prepare(xid));

        _xaRes.forget(xid);
        _xaRes.start(xid, XAResource.TMNOFLAGS);
        _xaRes.end(xid, XAResource.TMSUCCESS);
        _xaCon.close();
        assertEquals("3", XAResource.XA_RDONLY, _xaRes.prepare(xid));
    }

    public void testCommit() throws Exception {
        Xid xid = new XidImpl();
        _xaRes.start(xid, XAResource.TMNOFLAGS);
        _xaRes.end(xid, XAResource.TMSUCCESS);
        _xaRes.commit(xid, true);
    }

    public void testRollback() throws Exception {
        Xid xid = new XidImpl();
        _xaRes.start(xid, XAResource.TMNOFLAGS);
        _xaRes.end(xid, XAResource.TMFAIL);
        _xaRes.rollback(xid);
    }

    protected void setUp() throws Exception {
        XADataSourceImpl ds = new XADataSourceImpl();
        ds.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        ds.setURL("jdbc:oracle:thin:@d1606:1521:ark");
        ds.setUser("ark");
        ds.setPassword("ark");
        _xaCon = (XAConnectionImpl) ds.getXAConnection();
        _xaRes = _xaCon.getXAResource();
    }

    protected void tearDown() throws Exception {
        _xaCon.close();
    }

    public static Test suite ( ) {
        return new TestSuite(SQLXAResourceTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SQLXAResourceTest.class.getName()});
    }
}