package test.org.seasar.nazuna;

import org.seasar.nazuna.NazunaURL;

public class NazunaURLTest extends NazunaServiceTestCase {

	public NazunaURLTest(String arg0) {
		super(arg0);
	}

	public void testConstructor() throws Exception {
		NazunaURL url = new NazunaURL("rmi://d1345:1108");
		assertEquals("1", "rmi", url.getProtocol());
		assertEquals("2", "d1345", url.getHost());
		assertEquals("3", 1108, url.getPort());
	}

	public void testExecuteRulet() throws Exception {
		NazunaURL url =
			new NazunaURL("rmi://localhost:" + _rmiAdaptorService.getPort());
		assertEquals("1", new Integer(3), url.executeRulet(
			"test.org.seasar.nazuna.AddRulet", new Object[]{new Integer(1), new Integer(2)}));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(NazunaURLTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

}
