package test.org.seasar.nazuna;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.NazunaRemoting;
import org.seasar.nazuna.NazunaURL;
import org.seasar.nazuna.RemoteLocation;

public class NazunaTest3 extends NazunaServiceTestCase {

	private static final String HELLO_RULET = "test.org.seasar.nazuna.HelloRulet";
	
	public NazunaTest3(String arg0) {
		super(arg0);
	}

	public void testExecuteRulet() throws Exception {
		NazunaURL url =
			new NazunaURL("rmi://localhost:" + _rmiAdaptorService.getPort());
		RemoteLocation loc = new RemoteLocation("remote");
		loc.addURL(url);
		NazunaRemoting.addRemoteLocation(loc);
		NazunaRemoting.addRuleLocation(HELLO_RULET, "remote");
		assertEquals("1", "hello", Nazuna.executeRulet(HELLO_RULET));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(NazunaTest3.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		NazunaRemoting.init();
	}

}
