package test.org.seasar.nazuna;


import org.seasar.nazuna.LocalLocation;
import org.seasar.nazuna.NazunaRemoting;
import org.seasar.nazuna.RemoteLocation;

import junit.framework.TestCase;

public class NazunaRemotingTest extends TestCase {
	
	public NazunaRemotingTest(String arg0) {
		super(arg0);
	}
	
	public void testConfigure() throws Exception {
		String fileName = "/test/org/seasar/nazuna/nazuna-remoting.xml";
		NazunaRemoting.configure(fileName);
	
		RemoteLocation rl = (RemoteLocation) NazunaRemoting.getLocationByName("remote");
		assertEquals("1", 2, rl.getURLSize());
		assertEquals("2", "rmi://foo:1108", rl.getURL(0).getSpec());
		assertEquals("3", "rmi://bar:1108", rl.getURL(1).getSpec());
		
		assertEquals("4", LocalLocation.class, NazunaRemoting.getLocationByName("local").getClass());
		assertEquals("5", LocalLocation.class, NazunaRemoting.getDefaultLocation().getClass());
		
		String ruletName = "aaa.RemoteRulet";
		assertEquals("6", rl, NazunaRemoting.getLocationByRuleName(ruletName));
		assertEquals("7", NazunaRemoting.getDefaultLocation(),
			NazunaRemoting.getLocationByRuleName("hoge"));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(NazunaRemotingTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		NazunaRemoting.init();
	}

}
