package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.GetVariableExp;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.MethodExp;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.RuleContextImpl;

public class MethodExpTest extends TestCase {

    public MethodExpTest(String name) {
        super(name);
    }
    
    public static String foo(Object o) {
    	return o.toString();
    }
    
    public void testEvaluateValue() throws Exception {
    	List argExps = new ArrayList();
    	argExps.add(new IntegerExp(new Integer(1)));
    	Expression exp = new MethodExp("java.lang.String", "valueOf",
    		NazunaUtil.toExpressionArray(argExps));
        assertEquals("1", "1", exp.evaluateValue(null));
    }
    
    public void testEvaluateValue2() throws Exception {
    	List argExps = new ArrayList();
    	argExps.add(new DoubleExp(new Double(4)));
    	Expression exp = new MethodExp("java.lang.Math", "sqrt",
    		NazunaUtil.toExpressionArray(argExps));
        assertEquals("1", new Double(2.0), exp.evaluateValue(null));
    }
    
    public void testEvaluateValue3() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("str", String.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	List argExps = new ArrayList();
    	Expression exp = new MethodExp("str", "toUpperCase",
    		NazunaUtil.toExpressionArray(argExps));
    	Map parameters = new HashMap();
    	parameters.put("str", "abc");
        assertEquals("1", "ABC", exp.evaluateValue(new RuleContextImpl(rule, parameters)));
    }
    
    public void testEvaluateValue4() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("a", String.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	List argExps = new ArrayList();
    	argExps.add(new GetVariableExp("a"));
    	Expression exp = new MethodExp("test.org.seasar.nazuna.MethodExpTest", "foo",
    		NazunaUtil.toExpressionArray(argExps));
    	Map parameters = new HashMap();
    	parameters.put("a", "abc");
        assertEquals("1", "abc", exp.evaluateValue(new RuleContextImpl(rule, parameters)));
    }
    
    public void testEvaluateValue5() throws Exception {
    	Flowlet rule = new Flowlet();
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("a", Map.class);
    	inputType.addArgType(argType);
    	rule.setInputType(inputType);
    	
    	Expression exp = new MethodExp("a.b", "toUpperCase",
    		Expression.EMPTY_EXPRESSIONS);
    	Map parameters = new HashMap();
    	Map a = new HashMap();
    	a.put("b", "abc");
    	parameters.put("a", a);
        assertEquals("1", "ABC", exp.evaluateValue(new RuleContextImpl(rule, parameters)));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(MethodExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{MethodExpTest.class.getName()});
    }
}