package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.LessThanExp;
import org.seasar.nazuna.NullExp;

public class LessThanExpTest extends TestCase {

    public LessThanExpTest(String name) {
        super(name);
    }

	public void testEvaluate() throws Exception {
    	String s = "1234567890";
    	String s2 = "1234567891";
        Integer i = new Integer(s);
        Integer i2 = new Integer(s2);
        IntegerExp iExp = new IntegerExp(i);
        IntegerExp i2Exp = new IntegerExp(i2);
        LessThanExp ltExp = new LessThanExp(iExp, iExp);
        assertEquals("1", false, ltExp.evaluate(null));
        
        LessThanExp lt2Exp = new LessThanExp(i2Exp, iExp);
        assertEquals("2", false, lt2Exp.evaluate(null));
        
        LessThanExp lt3Exp = new LessThanExp(iExp, i2Exp);
        assertEquals("3", true, lt3Exp.evaluate(null));
        
        Expression nullExp = new NullExp();
        LessThanExp lt4Exp = new LessThanExp(iExp, nullExp);
        assertEquals("4", false, lt4Exp.evaluate(null));
        
        LessThanExp lt5Exp = new LessThanExp(nullExp, iExp);
        assertEquals("5", false, lt5Exp.evaluate(null));
        
        LessThanExp lt6Exp = new LessThanExp(nullExp, nullExp);
        assertEquals("6", false, lt6Exp.evaluate(null));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(LessThanExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{LessThanExpTest.class.getName()});
    }
}