package org.seasar.nazuna;

import java.util.List;
import java.util.Map;

import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class SqletContainer {

	private static Map _sqletDeployers = new SMap(89);

	private SqletContainer() {
	}

	public static final List executeQuery(String name, Map parameters)
		throws SeasarException {

		return getSqlet(name).executeQuery(parameters);
	}

	public static final List executeQuery(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NazunaConstants.NULL_ARGS;
		}
		Sqlet sqlet = getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return sqlet.executeQuery();
		}
		return sqlet.executeQuery(inputType.convertArgsToMap(args));
	}

	public static final NzRecordSet executeRSQuery(String name, Map parameters)
		throws SeasarException {

		return getSqlet(name).executeRSQuery(parameters);
	}

	public static final NzRecordSet executeRSQuery(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NazunaConstants.NULL_ARGS;
		}
		Sqlet sqlet = getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return sqlet.executeRSQuery();
		}
		return sqlet.executeRSQuery(inputType.convertArgsToMap(args));
	}

	public static final Object executeSingleQuery(String name, Map parameters)
		throws SeasarException {

		return getSqlet(name).executeSingleQuery(parameters);
	}

	public static final Object executeSingleQuery(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NazunaConstants.NULL_ARGS;
		}
		Sqlet sqlet = getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return sqlet.executeSingleQuery();
		}
		return sqlet.executeSingleQuery(inputType.convertArgsToMap(args));
	}

	public static final int executeUpdate(String name, Map parameters)
		throws SeasarException {

		return getSqlet(name).executeUpdate(parameters);
	}

	public static final int executeUpdate(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NazunaConstants.NULL_ARGS;
		}
		Sqlet sqlet = getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return sqlet.executeUpdate();
		}
		return sqlet.executeUpdate(inputType.convertArgsToMap(args));
	}

	public static Sqlet getSqlet(String name) throws SeasarException {
		SqletDeployer deployer = getSqletDeployer(name);
		deployer.deploy();
		return deployer.getSqlet();
	}

	public static SqletDeployer getSqletDeployer(String name)
		throws SeasarException {

		name = name.intern();
		SqletDeployer deployer = (SqletDeployer) _sqletDeployers.get(name);
		if (deployer != null) {
			return deployer;
		}
		synchronized (_sqletDeployers) {
			deployer = (SqletDeployer) _sqletDeployers.get(name);
			if (deployer == null) {
				deployer = new SqletDeployer(name);
				_sqletDeployers.put(name, deployer);
			}
		}
		return deployer;
	}
}
