package org.seasar.nazuna;

import java.lang.reflect.Method;
import java.util.Map;

import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public class Flowlet extends RuleBase {
	
	private static Method _executeRealMethod = Reflector.getMethod(Flowlet.class,
		"executeReal", new Class[]{Map.class});
	
	public Flowlet() {
	}
	
	public final Object execute() throws SeasarException {
		return execute(null);
	}
	
	public final Object execute(Map parameters) throws SeasarException {
		return getTransAttribute().invoke(
			_executeRealMethod, this, new Object[]{parameters});
	}
	
	public final Object executeReal(Map parameters) throws SeasarException {				
		RuleContext ctx = new RuleContextImpl(this, parameters);
		for (int i = 0; i < _ruleStatements.length; ++i) {
			RuleStatement ruleStatement = _ruleStatements[i];
			ruleStatement.execute(ctx);
			if (ctx.isReturned()) {
				return ctx.getReturnValue();
			}
			if (ctx.isThrowed()) {
				ctx.throwSeasarExcepton();
			}
		}
		return null;
	}
}