package org.seasar.nazuna;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class BeanResultType extends ResultType {

	public BeanResultType(Class resultClass) {
		super(resultClass);
	}

	public final List fetch(ResultSet rs) throws SeasarException {
		List results = new ArrayList();
		try {
			while (rs.next()) {
				Object bean = Reflector.newInstance(_resultClass);
				for (int i = 0; i < _propertyTypes.length; ++i) {
					_propertyTypes[i].fetch(rs, bean);
				}
				results.add(bean);
			}
		} catch (SQLException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
		return results;
	}

	public void addPropertyType(
		String propertyName,
		String columnName,
		String typeName) {
			
		Method setterMethod =
			Reflector.getWriteMethod(_resultClass, propertyName);
		ValueType valueType =
			ValueType.getType(setterMethod.getParameterTypes()[0]);
		addPropertyType(
			new BeanPropertyType(
				propertyName,
				columnName,
				valueType,
				setterMethod));
	}
}
