package examples.org.seasar;

import java.sql.Connection;
import java.sql.Statement;

import org.seasar.util.SeasarContext;

public class SeasarContextExample {

	private static final String SQL =
		"UPDATE emp SET ename='SCOTT' WHERE empno = 7788";
	
	public static void main(String[] args) {
		try {
			SeasarContext ctx = SeasarContext.getInstance();
			Connection con = null;
			Statement stmt = null;
			ctx.begin();
			try {
				con = ctx.getConnection();
				stmt = con.createStatement();
				int rows = stmt.executeUpdate(SQL);
				System.out.println("updated " + rows + " row(s)");
				ctx.commit();
			} catch (Exception ex) {
				ctx.rollback();
				ex.printStackTrace();
			} finally {
				if (stmt != null) {
					stmt.close();
				}
				if (con != null) {
					con.close();
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
