/*
class seasar.unit.Assert

public:
void assertTrue(boolean condition)
void assertNull(Object object)
void assertNotNull(Object object)
void assertDefined(Object object)
void assertUndefined(Object object)
void assertEquals(Object expected, Object actual)

package:
void prepare(seasar.unit.TestResult testResult, String methodName)

private:
seasar.unit.testResult testResult
String methodName
Number seq
void success()
void fail(String message)
*/
if (seasar.unit.Assert === undefined) {
	#include "seasar/lang/SObject.as"
	#include "seasar/unit/TestResult.as"
	#include "seasar/unit/TestFailure.as"
	
	seasar.lang.SObject.defineClass("seasar.unit.Assert", null,
		["testResult", "methodName", "seq"]);
		
	var proto = seasar.unit.Assert.prototype;
	
	proto.prepare = function(testResult, methodName) {
		this.testResult = testResult;
		this.methodName = methodName;
		this.seq = 0;
	}
	
	proto.success = function() {
		this.testResult.addSuccess();
	}
	
	proto.fail = function(message) {
		var failure = new seasar.unit.TestFailure(
			this.constructor.name, this.methodName, message);
		this.testResult.addFailure(failure);
	}
	
	proto.assertTrue = function() {
		if (arguments.length == 2) {
			var message = arguments[0];
			var condition = arguments[1];
		} else {
			var message = ++this.seq;
			var condition = arguments[0];
		}
		if (condition) {
			this.success();
		} else {
			this.fail(message + " expected true");
		}
	}
	
	proto.assertNull = function() {
		if (arguments.length == 2) {
			var message = arguments[0];
			var obj = arguments[1];
		} else {
			var message = ++this.seq;
			var obj = arguments[0];
		}
		if (obj == null) {
			this.success();
		} else {
			this.fail(message + " expected null");
		}
	}
	
	proto.assertNotNull = function() {
		if (arguments.length == 2) {
			var message = arguments[0];
			var obj = arguments[1];
		} else {
			var message = ++this.seq;
			var obj = arguments[0];
		}
		if (obj !== null) {
			this.success();
		} else {
			this.fail(message + " expected not null");
		}
	}
	
	proto.assertDefined = function() {
		if (arguments.length == 2) {
			var message = arguments[0];
			var obj = arguments[1];
		} else {
			var message = ++this.seq;
			var obj = arguments[0];
		}
		if (obj !== undefined) {
			this.success();
		} else {
			this.fail(message + " expected defined");
		}
	}
	
	proto.assertUndefined = function() {
		if (arguments.length == 2) {
			var message = arguments[0];
			var obj = arguments[1];
		} else {
			var message = ++this.seq;
			var obj = arguments[0];
		}
		if (obj === undefined) {
			this.success();
		} else {
			this.fail(message + " expected undefined");
		}
	}
	
	proto.assertEquals = function() {
		if (arguments.length == 3) {
			var message = arguments[0];
			var expected = arguments[1];
			var actual = arguments[2];
		} else {
			var message = ++this.seq;
			var expected = arguments[0];
			var actual = arguments[1];
		}
		if (expected == null && actual == null) {
			this.success();
		} else if (expected != null && expected == actual) {
			this.success();
		} else {
			this.fail(message + " expected:<" + expected + "> but was:<" + actual + ">");
		}
	}
	
	ASSetPropFlags(proto,"testResult,methodName,seq,prepare,success,fail,assertTrue,assertNull,assertNotNull,assertDefined,assertUndefined,assertEquals",1);

	delete proto;
}