package org.seasar.nazuna;

import java.util.Iterator;
import java.util.Map;

import org.seasar.log.Logger;
import org.seasar.util.ArrayUtil;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class RuletContainer {

	private static Map _ruletDeployers = new SMap();

	static {
		addShutdownHook();
	}

	private RuletContainer() {
	}

	public static final Object executeRulet(String className, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = ArrayUtil.EMPTY_OBJECTS;
		}
		return getRuletFacade(className).executeRulet(args);
	}

	public static final RuletFacade getRuletFacade(String className)
		throws SeasarException {

		RuletDeployer deployer = getRuletDeployer(className);
		deployer.deploy();
		return deployer.getRuletFacade();
	}

	public static final RuletDeployer getRuletDeployer(String className) {
		className = className.intern();
		RuletDeployer deployer = (RuletDeployer) _ruletDeployers.get(className);
		if (deployer != null) {
			return deployer;
		}
		synchronized (_ruletDeployers) {
			deployer = (RuletDeployer) _ruletDeployers.get(className);
			if (deployer != null) {
				return deployer;
			}
			deployer = new RuletDeployer(className);
			_ruletDeployers.put(className, deployer);
		}
		return deployer;
	}

	public static final synchronized void destroyAll() {
		for (Iterator i = _ruletDeployers.keySet().iterator(); i.hasNext();) {
			String className = (String) i.next();
			RuletDeployer deployer =
				(RuletDeployer) _ruletDeployers.get(className);
			try {
				deployer.destroy();
			} catch (Throwable t) {
				Logger.getLogger(RuletContainer.class).log(t);
			}
		}
		_ruletDeployers.clear();
	}

	private static void addShutdownHook() {
		Thread t = new Thread() {
			public void run() {
				destroyAll();
			}
		};
		t.setDaemon(true);
		Runtime.getRuntime().addShutdownHook(t);
	}
}
