package org.seasar.nazuna;

import java.util.List;
import java.util.Map;

import org.seasar.system.JMXUtil;
import org.seasar.system.MBeanProxy;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class NazunaURL {

	private String _spec;
	private String _protocol;
	private String _host;
	private int _port = 0;
	private NazunaServiceMBean _nazunaService;

	public NazunaURL(String spec) {
		Assertion.assertNotNull("spec", spec);

		_spec = spec;
		String protocol = null;
		int pos = spec.indexOf("://");
		_protocol = spec.substring(0, pos);
		int colonPos = spec.lastIndexOf(':');
		if (colonPos > pos) {
			_host = spec.substring(pos + 3, colonPos);
			_port = Integer.parseInt(spec.substring(colonPos + 1));
		} else {
			_host = spec.substring(pos + 3, colonPos);
		}
		_nazunaService =
			(NazunaServiceMBean) MBeanProxy.create(
				NazunaServiceMBean.class,
				JMXUtil.getMBeanName("nazuna"),
				_host,
				_port);
	}

	public final String getSpec() {
		return _spec;
	}

	public final String getProtocol() {
		return _protocol;
	}

	public final String getHost() {
		return _host;
	}

	public final int getPort() {
		return _port;
	}

	public final Object executeRulet(String className, Object[] args)
		throws SeasarException {

		return _nazunaService.executeRulet(className, args);
	}

	public final Object execute(String className, Map parameters)
		throws SeasarException {

		return _nazunaService.execute(className, parameters);
	}

	public final Object execute(String className, Object[] args)
		throws SeasarException {

		return _nazunaService.execute(className, args);
	}

	public final List executeQuery(String className, Map parameters)
		throws SeasarException {

		return _nazunaService.executeQuery(className, parameters);
	}

	public final List executeQuery(String className, Object[] args)
		throws SeasarException {

		return _nazunaService.executeQuery(className, args);
	}

	public final NzRecordSet executeRSQuery(String className, Map parameters)
		throws SeasarException {

		return _nazunaService.executeRSQuery(className, parameters);
	}

	public final NzRecordSet executeRSQuery(String className, Object[] args)
		throws SeasarException {

		return _nazunaService.executeRSQuery(className, args);
	}

	public final Object executeSingleQuery(String className, Map parameters)
		throws SeasarException {

		return _nazunaService.executeSingleQuery(className, parameters);
	}

	public final Object executeSingleQuery(String className, Object[] args)
		throws SeasarException {

		return _nazunaService.executeSingleQuery(className, args);
	}

	public final int executeUpdate(String className, Map parameters)
		throws SeasarException {

		return _nazunaService.executeUpdate(className, parameters);
	}

	public final int executeUpdate(String className, Object[] args)
		throws SeasarException {

		return _nazunaService.executeUpdate(className, args);
	}

	public final String toString() {
		return getSpec();
	}
}
