package org.seasar.eclipse.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.seasar.eclipse.SeasarLauncher;

public class ShutdownSeasarAction implements IWorkbenchWindowActionDelegate {
	
	private IWorkbenchWindow _window;

	public ShutdownSeasarAction() {
	}

	public void run(IAction action) {
		try {
			SeasarLauncher.shutdownSeasar();
		} catch (CoreException ex) {
			MessageDialog.openInformation(
				_window.getShell(),
				"Seasar Plugin",
				ex.getMessage());
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
		_window = window;
	}
}