package test.org.seasar.nazuna;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.NzRecordSet;
import org.seasar.util.SeasarException;

import test.org.seasar.sql.ConnectionPoolTestCase;

public class NazunaTest2 extends ConnectionPoolTestCase {

	public NazunaTest2(String name) {
		super(name);
	}

	public void testExecuteQuery() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		List results = Nazuna.executeQuery(name, new Integer(7369));
		assertEquals("1", 1, results.size());
	}

	public void testExecuteSingleQuery() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		Object result = Nazuna.executeSingleQuery(name, new Integer(7369));
		assertNotNull("1", result);
	}

	public void testExecuteSingleQuery2() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		Object result = Nazuna.executeSingleQuery(name, new Integer(-1));
		assertNull("1", result);
	}

	public void testExecuteSingleQuery3() throws Exception {
		String name = "test.org.seasar.nazuna.select";
		try {
			Nazuna.executeSingleQuery(name);
			fail("1");
		} catch (SeasarException ex) {
			if (ex.getMessageCode().equals("ESSR0362")) {
				System.out.println(ex);
			} else {
				throw ex;
			}
		}
	}

	public void testExecuteRSQuery() throws Exception {
		String name = "test.org.seasar.nazuna.select2";
		NzRecordSet results = Nazuna.executeRSQuery(name, new Integer(7369));
		assertEquals("1", 1, results.getRows().size());
	}

	public void testExecuteUpdate() throws Exception {
		String name = "test.org.seasar.nazuna.update";
		Employee employee = new Employee();
		employee.setEmployeeNo(7788);
		employee.setEmployeeName("SCOTT");
		assertEquals("1", 1, Nazuna.executeUpdate(name, employee));
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static Test suite() {
		return new TestSuite(NazunaTest2.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NazunaTest2.class.getName()});
	}
}