package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class WhereChildTag extends AbstractRuleStatement {
	
	private String _appendText;
	private TextTagFragment[] _fragments;
	
	public WhereChildTag(Object parent, String location,
			String appendText, String text) throws SeasarException {
				
		super(parent, location);
		Assertion.assertNotNull("appendText", appendText);
		Assertion.assertNotNull("text", text);
		
		_appendText = appendText;
		_fragments = TextTagFragment.parse(text);
	}
	
	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			if (!ruleContext.isWhereEnabled()) {
				ruleContext.addLineSeparaterText();
				ruleContext.addText("WHERE ");
				ruleContext.enableWhere();
			} else {
				ruleContext.addLineSeparaterText();
				ruleContext.addText(_appendText);
			}
			for (int i = 0; i < _fragments.length; ++i) {
				_fragments[i].execute(ruleContext);
			}
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}

}
