package org.seasar.nazuna;

import java.util.List;
import java.util.Map;

import org.seasar.util.ArrayUtil;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;

public final class Nazuna {

	public static final String CONFIG_FILE_PATH = "/nazuna-config.xml";
	private static NazunaConfig _nazunaConfig;
	private static Object[] NULL_ARGS = new Object[] { null };

	static {
		configure();
	}

	private Nazuna() {
	}

	public static final Object executeRulet(String className)
		throws SeasarException {

		return executeRulet(className, ArrayUtil.EMPTY_OBJECTS);
	}

	public static final Object executeRulet(String className, Object arg0)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0 });
	}

	public static final Object executeRulet(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0, arg1 });
	}

	public static final Object executeRulet(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0, arg1, arg2 });
	}

	public static final Object executeRulet(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0, arg1, arg2, arg3 });
	}

	public static final Object executeRulet(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeRulet(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public static final Object executeRulet(String className, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NULL_ARGS;
		}
		RuletFacade facade = RuletContainer.getRuletFacade(className);
		return facade.execute(args);
	}

	public static Object execute(final String name) throws SeasarException {
		Flowlet flowlet = FlowletContainer.getFlowlet(name);
		return flowlet.execute();
	}

	public static Object execute(final String name, final Map parameters)
		throws SeasarException {

		Flowlet flowlet = FlowletContainer.getFlowlet(name);
		return flowlet.execute(parameters);
	}

	public static final Object execute(String className, Object arg0)
		throws SeasarException {

		return execute(className, new Object[] { arg0 });
	}

	public static final Object execute(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return execute(className, new Object[] { arg0, arg1 });
	}

	public static final Object execute(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return execute(className, new Object[] { arg0, arg1, arg2 });
	}

	public static final Object execute(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return execute(className, new Object[] { arg0, arg1, arg2, arg3 });
	}

	public static final Object execute(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return execute(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public static final Object execute(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NULL_ARGS;
		}
		Flowlet flowlet = FlowletContainer.getFlowlet(name);
		InputType inputType = flowlet.getInputType();
		if (inputType == null) {
			return execute(name);
		}
		return execute(name, inputType.convertArgsToMap(args));
	}

	public static List executeQuery(final String name) throws SeasarException {
		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeQuery();
	}

	public static List executeQuery(final String name, final Map parameters)
		throws SeasarException {

		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeQuery(parameters);
	}

	public static final List executeQuery(String className, Object arg0)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0 });
	}

	public static final List executeQuery(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0, arg1 });
	}

	public static final List executeQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0, arg1, arg2 });
	}

	public static final List executeQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0, arg1, arg2, arg3 });
	}

	public static final List executeQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public static final List executeQuery(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NULL_ARGS;
		}
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return executeQuery(name);
		}
		return executeQuery(name, inputType.convertArgsToMap(args));
	}

	public static Object executeSingleQuery(final String name)
		throws SeasarException {

		Sqlet sqlet = SqletContainer.getSqlet(name);
		List results = sqlet.executeQuery();
		return getSingle(results);
	}

	public static Object executeSingleQuery(
		final String name,
		final Map parameters)
		throws SeasarException {

		Sqlet sqlet = SqletContainer.getSqlet(name);
		List results = sqlet.executeQuery(parameters);
		return getSingle(results);
	}

	public static final Object executeSingleQuery(
		String className,
		Object arg0)
		throws SeasarException {

		return executeSingleQuery(className, new Object[] { arg0 });
	}

	public static final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeSingleQuery(className, new Object[] { arg0, arg1 });
	}

	public static final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeSingleQuery(className, new Object[] { arg0, arg1, arg2 });
	}

	public static final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeSingleQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3 });
	}

	public static final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeSingleQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public static final Object executeSingleQuery(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NULL_ARGS;
		}
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return executeSingleQuery(name);
		}
		return executeSingleQuery(name, inputType.convertArgsToMap(args));
	}

	public static NzRecordSet executeRSQuery(final String name)
		throws SeasarException {
		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeRSQuery();
	}

	public static NzRecordSet executeRSQuery(
		final String name,
		final Map parameters)
		throws SeasarException {

		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeRSQuery(parameters);
	}

	public static final NzRecordSet executeRSQuery(
		String className,
		Object arg0)
		throws SeasarException {

		return executeRSQuery(className, new Object[] { arg0 });
	}

	public static final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeRSQuery(className, new Object[] { arg0, arg1 });
	}

	public static final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeRSQuery(className, new Object[] { arg0, arg1, arg2 });
	}

	public static final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeRSQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3 });
	}

	public static final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeRSQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public static final NzRecordSet executeRSQuery(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NULL_ARGS;
		}
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return executeRSQuery(name);
		}
		return executeRSQuery(name, inputType.convertArgsToMap(args));
	}

	public static int executeUpdate(final String name) throws SeasarException {
		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeUpdate();
	}

	public static int executeUpdate(final String name, final Map parameters)
		throws SeasarException {

		Sqlet sqlet = SqletContainer.getSqlet(name);
		return sqlet.executeUpdate(parameters);
	}

	public static final int executeUpdate(String className, Object arg0)
		throws SeasarException {

		return executeUpdate(className, new Object[] { arg0 });
	}

	public static final int executeUpdate(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeUpdate(className, new Object[] { arg0, arg1 });
	}

	public static final int executeUpdate(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeUpdate(className, new Object[] { arg0, arg1, arg2 });
	}

	public static final int executeUpdate(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeUpdate(
			className,
			new Object[] { arg0, arg1, arg2, arg3 });
	}

	public static final int executeUpdate(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeUpdate(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public static final int executeUpdate(String name, Object[] args)
		throws SeasarException {

		if (args == null) {
			args = NULL_ARGS;
		}
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return executeUpdate(name);
		}
		return executeUpdate(name, inputType.convertArgsToMap(args));
	}

	public static NazunaConfig getNazunaConfig() {
		return _nazunaConfig;
	}

	private static void configure() {
		if (ResourceUtil.isExist(CONFIG_FILE_PATH)) {
			_nazunaConfig = NazunaConfigBuilder.parse(CONFIG_FILE_PATH);
		}
	}

	private static Object getSingle(List results) throws SeasarException {
		int size = results.size();
		switch (size) {
			case 1 :
				return results.get(0);
			case 0 :
				return null;
			default :
				throw new SeasarException("ESSR0362");
		}
	}
}