package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public final class MultDivModExp implements Expression {

    private final Expression _arg1Exp;
    private final Expression _arg2Exp;
    private int _token;

    public MultDivModExp(final Expression arg1Exp, final Expression arg2Exp,
    		int token) {
    			
    	Assertion.assertNotNull("arg1Exp", arg1Exp);
    	Assertion.assertNotNull("arg2Exp", arg2Exp);
    	Assertion.assertTrue(token == RuleTokenizer.MULTIPLY ||
    		token == RuleTokenizer.DIVIDE ||
    		token == RuleTokenizer.MOD,
    		"ESSR0003", "token", RuleTokenizer.getTokenName(token));
    	
        _arg1Exp = arg1Exp;
        _arg2Exp = arg2Exp;
        _token = token;
    }

	public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
        Number arg1 = (Number) _arg1Exp.evaluateValue(ruleContext);
        Number arg2 = (Number) _arg2Exp.evaluateValue(ruleContext);
        switch (_token) {
        	case RuleTokenizer.MULTIPLY:
        		return MathUtil.multiply(arg1, arg2);
        	case RuleTokenizer.DIVIDE:
        		return MathUtil.divide(arg1, arg2);
        	default:
        		return MathUtil.mod(arg1, arg2);
        }
    }
}