package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class FlowletContainer {

	private static Map _flowletDeployers = new SMap(89);
	
	private FlowletContainer() {
	}

	public static Flowlet getFlowlet(String name) throws SeasarException {
		FlowletDeployer deployer = getFlowletDeployer(name);
		deployer.deploy();
		return deployer.getFlowlet();
    }
    
    public static FlowletDeployer getFlowletDeployer(String name)
    		throws SeasarException {
    			
		name = name.intern();
        FlowletDeployer deployer = (FlowletDeployer) _flowletDeployers.get(name);
        if (deployer != null) {
        	return deployer;
        }
        synchronized (_flowletDeployers) {
        	deployer = (FlowletDeployer) _flowletDeployers.get(name);
            if (deployer == null) {
                deployer = new FlowletDeployer(name);
                _flowletDeployers.put(name, deployer);
            }    
        }
        return deployer;
    }
}
