package org.seasar.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.seasar.util.NetUtil;
import org.seasar.util.SeasarException;

public final class RMIAdaptorService extends AbstractSocketService {

	private static RMIAdaptorService _instance;
    private static RMIAdaptor _rmiAdaptor;
    private static RMIAdaptor _rmiAdaptorStub;

    public RMIAdaptorService() {
    	_instance = this;
    }
    
    public static RMIAdaptorService getInstance() {
    	return _instance;
    }

	public static RMIAdaptor getRMIAdaptor() {
    	return _rmiAdaptor;
    }
    
    public static RMIAdaptor getRMIAdaptorStub() {
    	return _rmiAdaptorStub;
    }
        
    public final void start() throws SeasarException {
    	try {
    		_rmiAdaptor = new RMIAdaptorImpl();
    		_rmiAdaptorStub = (RMIAdaptor) UnicastRemoteObject.exportObject(_rmiAdaptor);
    	} catch (RemoteException ex) {
    		throw SeasarException.convertSeasarException(ex);
    	}
    	super.start();
    	String[] hostNames = NetUtil.getAllHostName();
		for (int i = 0; i < hostNames.length; ++i) {
			RMIConnector.setRMIAdaptor(hostNames[i], getPort(), _rmiAdaptor);
		}
    }

    public final void stop() throws SeasarException {
        super.stop();
        try {
        	UnicastRemoteObject.unexportObject(_rmiAdaptor, true);
        } catch (RemoteException ex) {
    		throw SeasarException.convertSeasarException(ex);
    	} finally {
    		_rmiAdaptor = null;
    		_rmiAdaptorStub = null;
        }
    }

    protected final void handleSocket(final Socket socket) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        in.readInt();
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        out.writeObject(_rmiAdaptorStub);
        out.flush();
    }
}
