package org.seasar.sql;

import org.seasar.util.Assertion;
import org.seasar.util.EMap;

public final class ConnectionPoolManager {

    private static ConnectionPoolManager _instance = new ConnectionPoolManager();
    private EMap _connectionPools = new EMap();

    private ConnectionPoolManager() {
        Thread t =
        new Thread() {
            public void run() {
                close();
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(t);
        } catch (IllegalStateException ignore) {
        }
    }

    public static ConnectionPoolManager getInstance() {
        return _instance;
    }

    public ConnectionPool getConnectionPool(final String dataSourceName) {
        ConnectionPool pool = (ConnectionPool) _connectionPools.get(dataSourceName);
        Assertion.assertFound(dataSourceName, pool);
        return pool;
    }
    
    public boolean hasConnectionPoolMetaData(final String dataSourceName) {
		Assertion.assertNotNull("dataSourceName", dataSourceName);
        return _connectionPools.containsKey(dataSourceName);
    }

    public synchronized void registerConnectionPoolMetaData(
            final ConnectionPoolMetaData connectionPoolMetaData) {

        Assertion.assertNotNull("connectionPoolMetaData", connectionPoolMetaData);
        if (_connectionPools.containsKey(connectionPoolMetaData.getDataSourceName())) {
            return;
        }
        _connectionPools.put(connectionPoolMetaData.getDataSourceName(),
                new ConnectionPool(connectionPoolMetaData));
    }

    public synchronized void close() {
        for (int i = 0; i < _connectionPools.size(); ++i) {
            ConnectionPool cp = (ConnectionPool) _connectionPools.get(i);
            cp.close();
        }
        _connectionPools.clear();
    }
}
