package test.org.seasar.transaction;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.transaction.TransactionManagerImpl;

public class TransactionManagerPerformanceTest extends TestCase {

    public TransactionManagerPerformanceTest(String name) {
        super(name);
    }

    public void testBeginCommit() throws Exception {
    	long start = System.currentTimeMillis();
        TransactionManagerImpl.getInstance().begin();
        System.out.println("begin:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        TransactionManagerImpl.getInstance().commit();
        System.out.println("commit:" + (System.currentTimeMillis() - start));
        
        start = System.currentTimeMillis();
        TransactionManagerImpl.getInstance().begin();
        System.out.println("begin2:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        TransactionManagerImpl.getInstance().commit();
        System.out.println("commit2:" + (System.currentTimeMillis() - start));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(TransactionManagerPerformanceTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{TransactionManagerPerformanceTest.class.getName()});
    }
}