package test.org.seasar.nazuna;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.Arg;
import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.InputType;
import org.seasar.util.SeasarRuntimeException;

public class InputTypeTest extends TestCase {

    public InputTypeTest(String name) {
        super(name);
    }
    
    public void testCreateArgs() throws Exception {
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("a", String.class);
    	ArgType argType2 = new ArgType("b", Integer.class);
    	inputType.addArgType(argType);
    	inputType.addArgType(argType2);
    	Map parameters = new HashMap();
    	parameters.put("a", "111");
    	Map args = inputType.createArgs(parameters);
    	assertEquals("1", 2, args.size());
    	Arg a = (Arg) args.get("a");
    	assertNotNull("2", a);
    	assertEquals("3", "111", a.getValue());
    	Arg b = (Arg) args.get("b");
    	assertNotNull("4", b);
    	assertEquals("5", null, b.getValue());
    }
    
    public void testAddArgType() throws Exception {
    	InputType inputType = new InputType();
    	ArgType argType = new ArgType("a", String.class);
    	inputType.addArgType(argType);
    	try {
    		inputType.addArgType(argType);
    		fail("1");
    	} catch (SeasarRuntimeException ex) {
    		System.out.println(ex);
    	}
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(InputTypeTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{InputTypeTest.class.getName()});
    }
}