package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.MatchExp;
import org.seasar.nazuna.StringExp;
import org.seasar.util.RegExp;

public class MatchExpTest extends TestCase {

    public MatchExpTest(String name) {
        super(name);
    }

	public void testEvaluate() throws Exception {
		assertEquals("1", true, RegExp.match("[a-zA-Z]*", "abcAbe"));
		Expression strExp = new StringExp("abcAbe");
		Expression regexpExp = new StringExp("[a-zA-Z]*");
		BooleanExpression exp = new MatchExp(strExp, regexpExp);
		assertEquals("2", true, exp.evaluate(null));
	}
	
	public void testEvaluate2() throws Exception {
		assertEquals("1", true, RegExp.matchIgnoreCase("[a-z]*", "aBcAbe"));
		Expression strExp = new StringExp("aBcAbe");
		Expression regexpExp = new StringExp("[a-z]*");
		BooleanExpression exp = new MatchExp(strExp, regexpExp, true);
		assertEquals("2", true, exp.evaluate(null));
	}

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(MatchExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{MatchExpTest.class.getName()});
    }
}