package org.seasar.system;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.seasar.log.Logger;
import org.seasar.util.SeasarRuntimeException;

public final class SeasarServlet extends HttpServlet {

    public void init() {
        try {
            if (!Seasar.getInstance().isStarted()) {
                Seasar.getInstance().start();
            }
        } catch (Throwable t) {
            Logger.getLogger(getClass()).log(t);
            throw SeasarRuntimeException.convertSeasarRuntimeException(t);
        }
    }

    public void destroy() {
        Seasar.getInstance().stop();
    }

    public final void doGet(final HttpServletRequest request, final HttpServletResponse response)
            throws IOException, ServletException {

        process(request, response);
    }

    public final void doPost(final HttpServletRequest request, final HttpServletResponse response)
            throws IOException, ServletException {

        process(request, response);
    }

    public final void process(final HttpServletRequest request, final HttpServletResponse response)
            throws IOException, ServletException {

        response.getWriter().write("My name is seasar.");
    }
}