package org.seasar.nazuna;

import java.util.List;

import org.seasar.util.SeasarException;


public interface RuleContext {
	
	public RuleBase getOwner();
		
	public Object getValue(String name) throws SeasarException;
	
	public Arg getArg(String name);
	
	public Var getVar(String name);
	
	public void setVarValue(String name, Object value)
			throws SeasarException;
	
	public Object getReturnValue();
	
	public void setReturnValue(Object returnValue) throws SeasarException;
	
	public boolean isReturned();
	
	public void clearReturned();
	
	public void throwSeasarExcepton() throws SeasarException;
	
	public void setThrowable(Throwable throwable, String location);
	
	public boolean isThrowed();
	
	public void clearThrowed();
	
	public boolean isBreaked();
	
	public boolean isBreaked(String label);
	
	public void setBreak(String forLabel) throws SeasarException;
	
	public boolean isContinued();
	
	public boolean isContinued(String label);
	
	public void clearForState();
	
	public void setContinue(String forLabel) throws SeasarException;
	
	public boolean isWhenBreaked();
	
	public void clearWhenBreaked();
	
	public void breakWhen();
	
	public String getText();
	
	public void addText(String text);
	
	public void addLineSeparaterText();
	
	public boolean isEmptyText();
	
	public void addBindVariable(Object bindVariable);
	
	public void addBindVariables(List bindVariables);
	
	public List getBindVariables();
	
	public boolean isWhereEnabled();
	
	public void enableWhere();
}
