package org.seasar.nazuna;

import org.seasar.util.SeasarException;

public final class NotEqualExp extends AbstractCompareExp {

    public NotEqualExp(final Expression arg1Exp, final Expression arg2Exp) {
        super(arg1Exp, arg2Exp);
    }

    public boolean evaluate(final RuleContext ruleContext) throws SeasarException {
        Comparable arg1 = getArg1(ruleContext);
        Comparable arg2 = getArg2(ruleContext);
        if (arg1 == null && arg2 == null) {
            return false;
        } else if (arg1 == null || arg2 == null) {
            return true;
        } else {
            return arg1.compareTo(arg2) != 0;
        }
    }
}
