package org.seasar.eclipse;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;

public final class SeasarLauncher {

	private static String BOOTSTRAP_CLASS_NAME = "org.seasar.boot.Bootstrap";
	private static String SEASAR_CLASS_NAME = "org.seasar.system.Seasar";
	private static String JETTY_SERVICE_CLASS_NAME = "org.seasar.jetty.JettyService";
	private static String[] EMPTY_STRINGS = new String[0];
	
	private SeasarLauncher() {
	}

	public static void startSeasar() throws CoreException {
		String[] seasarArgs = new String[]{SEASAR_CLASS_NAME, "-start"};
		runVM(seasarArgs);
	}
	
	public static void shutdownSeasar() throws CoreException {
		String[] seasarArgs = new String[]{SEASAR_CLASS_NAME, "-shutdown"};
		runVM(seasarArgs);
	}
	
	public static void restartSeasar() throws CoreException {
		String[] seasarArgs = new String[]{SEASAR_CLASS_NAME, "-restart"};
		runVM(seasarArgs);
	}
	
	public static void restartJetty() throws CoreException {
		String[] seasarArgs = new String[]
			{SEASAR_CLASS_NAME, "-restart", JETTY_SERVICE_CLASS_NAME};
		runVM(seasarArgs);
	}
	
	private static void runVM(String[] seasarArgs) throws CoreException {
		IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
		IVMRunner vmRunner = vmInstall.getVMRunner(ILaunchManager.DEBUG_MODE);
		ILaunchConfigurationWorkingCopy launchConfig = getLaunchConfiguration();		
		Launch launch = new Launch(launchConfig, ILaunchManager.DEBUG_MODE, getSourceLocator());
		launchConfig.doSave();
		VMRunnerConfiguration vmConfig =
			new VMRunnerConfiguration(BOOTSTRAP_CLASS_NAME, getClasspath());
		vmConfig.setVMArguments(EMPTY_STRINGS);
		vmConfig.setProgramArguments(seasarArgs);
		vmConfig.setBootClassPath(null);
		vmRunner.run(vmConfig, launch, null);
		DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
	}
	
	private static ILaunchConfigurationType getLaunchConfigurationType() {
		return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(
			"org.eclipse.jdt.launching.localJavaApplication");
	}
	
	private static ILaunchConfigurationWorkingCopy getLaunchConfiguration()
			throws CoreException {
				
		ILaunchConfigurationType launchType = getLaunchConfigurationType();
		ILaunchConfigurationWorkingCopy config = launchType.newInstance(null, "Seasar");
		config.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
		config.setAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE,
			IDebugUIConstants.PERSPECTIVE_DEFAULT);
		config.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE,
			IDebugUIConstants.PERSPECTIVE_DEFAULT);
		return config;
	}
	
	private static String[] getClasspath() {
		String[] classpath = new String[2];
		classpath[0] = getBootJarLocation();
		classpath[1] = getToolsJarLocation();
		return classpath;
	}
	
	private static String getSeasarHome() {
		return SeasarPlugin.getDefault().getSeasarHome();	
	}

	private static String getBootJarLocation() {
		return getSeasarHome() + File.separator + "bin" + File.separator + "boot.jar";
	}
	
	private static String getToolsJarLocation() {
		return JavaRuntime.getDefaultVMInstall().getInstallLocation() + 
			File.separator + "lib" + File.separator + "tools.jar";
	}
	
	private static ISourceLocator getSourceLocator() throws CoreException {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IProject[] projects = root.getProjects();
		ArrayList projectList = new ArrayList(projects.length);
		for (int i = 0; i < projects.length; ++i) {
			if ((projects[i].isOpen()) && projects[i].hasNature(JavaCore.NATURE_ID)) {
				projectList.add(projects[i].getNature(JavaCore.NATURE_ID));
			}
		}		
		IJavaProject[] javaProjects = (IJavaProject[])
			projectList.toArray(new IJavaProject[projectList.size()]);
		return new JavaSourceLocator(javaProjects, true);
	}

}

