package test.org.seasar.nazuna;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.Sqlet;
import org.seasar.nazuna.SqletBuilder;
import org.seasar.util.LineUtil;

public class SqletBuilderTest extends TestCase {

    public SqletBuilderTest(String name) {
        super(name);
    }
    
    public void testParse() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/select.xml";
    	Sqlet sql = SqletBuilder.parse(xmlFileName);
    	String text = "select * from emp" + LineUtil.LINE_SP + "order by empno";
    	RuleContext ctx = sql.execute();
    	assertEquals("1", text, ctx.getText());
    	assertNotNull("2", sql.getResultType());
    }
    
    public void testParse2() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/selectValue.xml";
    	Sqlet sql = SqletBuilder.parse(xmlFileName);
    	String text = "select * from emp" + LineUtil.LINE_SP +
    		"where deptno = 10 and sal >= 3000";
    	Map parameters = new HashMap();
    	parameters.put("deptno", new Integer(10));
    	parameters.put("sal", new BigDecimal(3000));
    	RuleContext ctx = sql.execute(parameters);
    	assertEquals("1", text, ctx.getText());
    }
    
    public void testParse3() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/selectBindVariable.xml";
    	Sqlet sql = SqletBuilder.parse(xmlFileName);
    	String text = "select * from emp" + LineUtil.LINE_SP +
    		"where deptno = ? and sal >= ?";
    	Map parameters = new HashMap();
    	parameters.put("deptno", new Integer(10));
    	parameters.put("sal", new BigDecimal(3000));
    	RuleContext ctx = sql.execute(parameters);
    	assertEquals("1", text, ctx.getText());
    	List bindVariables = ctx.getBindVariables();
    	assertEquals("2", 2, bindVariables.size());
    	assertEquals("3", new Integer(10), bindVariables.get(0));
    	assertEquals("4", new BigDecimal(3000), bindVariables.get(1));
    }
    
    public void testParse4() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/selectWhere.xml";
    	Sqlet sql = SqletBuilder.parse(xmlFileName);
    	String text = "select * from emp" + LineUtil.LINE_SP +
    		"WHERE empno = ?" + LineUtil.LINE_SP +
    		"order by empno";
    	Map parameters = new HashMap();
    	parameters.put("empno", new Integer(7788));
    	RuleContext ctx = sql.execute(parameters);
    	assertEquals("1", text, ctx.getText());
    	List bindVariables = ctx.getBindVariables();
    	assertEquals("2", 1, bindVariables.size());
    	assertEquals("3", new Integer(7788), bindVariables.get(0));
    	
    	String text2 = "select * from emp" + LineUtil.LINE_SP +
    		"order by empno";
    	RuleContext ctx2 = sql.execute();
    	assertEquals("4", text2, ctx2.getText());
    	List bindVariables2 = ctx2.getBindVariables();
    	assertEquals("5", 0, bindVariables2.size());
    }
    
    public void testParse5() throws Exception {
    	String xmlFileName = "/test/org/seasar/nazuna/selectWhere2.xml";
    	Sqlet sql = SqletBuilder.parse(xmlFileName);
    	String text = "select * from emp" + LineUtil.LINE_SP +
    		"WHERE sal is not null" + LineUtil.LINE_SP +
    		"OR comm is not null";
    	RuleContext ctx = sql.execute();
    	assertEquals("1", text, ctx.getText());
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(SqletBuilderTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SqletBuilderTest.class.getName()});
    }
}