package test.org.seasar.nazuna;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.RuletCompiler;
import org.seasar.nazuna.RuletDeployer;
import org.seasar.util.LineUtil;

public class RuletDeployerTest extends TestCase {

    public RuletDeployerTest(String name) {
        super(name);
    }

    public void testDeployFromSrc() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deployFromSrc();
    	assertNotNull("1", deployer.getRuletFacade());
    	assertEquals("2", deployer.getSrcFile().lastModified(), deployer.getLastModified());
    	assertEquals("3", "hello", deployer.getRuletFacade().execute(null));
    	deployer.deployFromSrc();
    	assertEquals("4", "hello", deployer.getRuletFacade().execute(null));
    }
    
    public void testDeployFromClass() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deployFromClass();
    	assertNotNull("1", deployer.getRuletFacade());
    	assertEquals("2", deployer.getClassFile().lastModified(), deployer.getLastModified());
    	assertEquals("3", "hello", deployer.getRuletFacade().execute(null));
    	deployer.deployFromClass();
    	assertEquals("4", "hello", deployer.getRuletFacade().execute(null));
    }
    
    public void testDefineClass() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	assertNotNull("1", deployer.defineClass());
    }
    
    public void testDeploy() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.getSrcFile().setLastModified(1);
    	deployer.getClassFile().setLastModified(2);
    	deployer.deploy();
    	assertEquals("1", 2, deployer.getLastModified());
    	deployer.getClassFile().setLastModified(3);
    	deployer.deploy();
    	assertEquals("2", 3, deployer.getLastModified());
    }
    
    public void testDeploy2() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.getSrcFile().setLastModified(3);
    	deployer.getClassFile().setLastModified(2);
    	deployer.deploy();
    	assertEquals("1", 3, deployer.getLastModified());
    	deployer.getSrcFile().setLastModified(4);
    	deployer.deploy();
    	assertEquals("2", 4, deployer.getLastModified());
    }
    
    public void testDeploy3() throws Exception {
    	String className = "test.org.seasar.nazuna.HelloRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.getSrcFile().setLastModified(4);
    	deployer.getClassFile().setLastModified(4);
    	deployer.deploy();
    	assertEquals("1", 4, deployer.getLastModified());
    	deployer.deploy();
    	assertEquals("2", 4, deployer.getLastModified());
    }
    
    public void testDeploy4() throws Exception {
    	String className = "test.org.seasar.nazuna.Hello2Rulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	writeHello2Rulet("hello");
    	deployer.deploy();
    	assertEquals("1", "hello", deployer.getRuletFacade().execute(null));
    	writeHello2Rulet("hello2");
    	deployer.deploy();
    	assertEquals("2", "hello2", deployer.getRuletFacade().execute(null));
    }
    
    public void testDeploy5() throws Exception {
    	String className = "test.org.seasar.nazuna.TestRulet";
    	RuletDeployer deployer = new RuletDeployer(className);
    	deployer.deploy();
    	Employee emp = (Employee) deployer.getRuletFacade().execute(null);
    	assertEquals("1", "SCOTT", emp.getEmployeeName());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(RuletDeployerTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{RuletDeployerTest.class.getName()});
    }
    
    private void writeHello2Rulet(String s) throws IOException {
    	String className = "test.org.seasar.nazuna.Hello2Rulet";
    	File srcFile = RuletCompiler.getSrcFile(className);
    	FileWriter writer = new FileWriter(srcFile);
    	writer.write("package test.org.seasar.nazuna;" + LineUtil.LINE_SP);
    	writer.write("import org.seasar.nazuna.Rulet;" + LineUtil.LINE_SP);
    	writer.write("public class Hello2Rulet extends Rulet {" + LineUtil.LINE_SP);
    	writer.write("public String doExecute() {" + LineUtil.LINE_SP);
    	writer.write("return \"" + s + "\";" + LineUtil.LINE_SP);
    	writer.write("}}");
    	writer.flush();
    	writer.close();
    }
}