package test.org.seasar.naming;

import junit.framework.*;
import javax.naming.*;
import org.seasar.naming.*;

public class NamingParserTest extends TestCase {

    public NamingParserTest(String name) {
        super(name);
    }

    public void testParse() throws Exception {
        Name name = NamingParser.getInstance().parse("http://localhost:7001");
        assertEquals("1", "http:", name.get(0));
        assertEquals("2", "", name.get(1));
        assertEquals("3", "localhost:7001", name.get(2));

        Name n2 = NamingParser.getInstance().parse("");
        System.out.println("isEmpty=" + n2.isEmpty());
        Name n3 = NamingParser.getInstance().parse("/");
        System.out.println("null character=" + n3.get(0).equals(""));
        Name n4 = NamingParser.getInstance().parse("test/");
        System.out.println("test/ of size=" + n4.size());
    }

    public void testSeparator() throws Exception {
        NamingParser.setSyntax("jndi.syntax.separator2", ".");
        Name n = NamingParser.getInstance().parse("a.b.c");
        assertEquals("1", "a/b/c", n.toString());

        Name n2 = NamingParser.getInstance().parse("a/b/c");
        assertEquals("2", "a/b/c", n2.toString());

        Name n3 = NamingParser.getInstance().parse("a/b.c");
        assertEquals("3", "a/b/c", n3.toString());
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(NamingParserTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{NamingParserTest.class.getName()});
    }
}