package org.seasar.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.sql.XAConnection;
import javax.sql.XADataSource;

import org.seasar.util.Reflector;

public final class XADataSourceImpl implements XADataSource {

    private String _driverClassName;
    private String _url;
    private String _user;
    private String _password;

    public XADataSourceImpl() { }

    public String getDriverClassName() {
        return _driverClassName;
    }

    public void setDriverClassName(final String driverClassName) {
        _driverClassName = driverClassName;
        if (driverClassName != null && driverClassName.length() > 0) {
            Reflector.newInstance(driverClassName);
        }
    }

    public String getURL() {
        return _url;
    }

    public void setURL(final String url) {
        _url = url;
    }

    public String getUser() {
        return _user;
    }

    public void setUser(final String user) {
        _user = user;
    }

    public String getPassword() {
        return _password;
    }

    public void setPassword(String password) {
        _password = password;
    }

    public XAConnection getXAConnection() throws SQLException {
        return getXAConnection(_user, _password);
    }

    public XAConnection getXAConnection(final String user, final String password)
             throws SQLException {

        Connection con = null;
        if (user == null || user.length() == 0) {
            con = DriverManager.getConnection(_url);
        } else {
            con = DriverManager.getConnection(_url, user, password);
        }
        return new XAConnectionImpl(con);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(final PrintWriter logWriter) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(final int loginTimeout) throws SQLException {
    }
}
