package org.seasar.nazuna;

import java.io.File;

import org.seasar.util.ResourceUtil;

public final class RuletClassLoader extends ClassLoader {

	public RuletClassLoader() {
		super(Thread.currentThread().getContextClassLoader());
	}

	public final Class defineClass(String className, File classFile) {
		return defineClass(className, ResourceUtil.getBytes(classFile));
	}
	
	public final Class defineClass(String className, byte[] bytes) {
		return defineClass(className, bytes, 0, bytes.length);
	}
}

