package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarRuntimeException;

public final class GroupElement {

    public static final GroupElement[] EMPTY_GROUP_ENTRYS = new GroupElement[0];
    private String _propertyName;
    private GroupType _groupType;
    private String _groupedPropertyName;

    public GroupElement(final String propertyName, final GroupType groupType,
            final String groupedPropertyName) {

        Assertion.assertNotNull("propertyName", propertyName);
        Assertion.assertNotNull("groupType", groupType);
        if (!groupType.equals(GroupType.COUNT) && groupedPropertyName == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"groupedPropertyName"});
        }
        
        _propertyName = propertyName;
        _groupType = groupType;
        _groupedPropertyName = groupedPropertyName;
    }

    public String getPropertyName() {
        return _propertyName;
    }

    public GroupType getGroupType() {
        return _groupType;
    }

    public String getGroupedPropertyName() {
        return _groupedPropertyName;
    }

    public GroupValue newGroupValue() {
        return _groupType.newGroupValue(this);
    }
}
