package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class ArgType {

	private String _name;
	private Class _argClass;

	public ArgType(String name, Class argClass) {
		Assertion.assertNotNull("name", name);
		Assertion.assertTrue(NazunaUtil.isVarArgStartChar(name.charAt(0)), "ESSR0036", null);
		Assertion.assertNotNull("argClass", argClass);

		_name = name;
		_argClass = argClass;			
	}
	
	public String getName() {
		return _name;
	}
	
	public Class getArgClass() {
		return _argClass;
	}
	
	public void validate(Object value) throws SeasarException {
		if (value != null && !_argClass.isInstance(value)) {
			throw new SeasarException("ESSR0002",
				new Object[]{_name, _argClass.getName(), value.getClass().getName()});
		}
	}
}
