package test.org.seasar.mbean;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.mbean.NotificationListenerContainer;
import org.seasar.system.JMXService;
import org.seasar.util.SeasarException;

import test.org.seasar.system.NotificationListenerTester;
import test.org.seasar.system.Notify;
import test.org.seasar.system.NotifyMBean;
import test.org.seasar.system.RMIAdaptorTestCase;

public class NotificationListenerContainerTest extends RMIAdaptorTestCase {

	private NotificationListenerContainer _listenerContainer;
	
    public NotificationListenerContainerTest(String name) throws Exception {
        super(name);
    }

	public void testStartAndStop() throws Exception {
		Notify notify = new Notify();
		JMXService.registerMBean(notify, NotifyMBean.NAME);
		
		_listenerContainer = new NotificationListenerContainer(
			NotificationListenerTester.class.getName(), "Notify");
		NotificationListenerTester listener = null;
    	_listenerContainer.start();
    	try {
   			listener = (NotificationListenerTester)
    			_listenerContainer.getNotificationListener();
    		assertNotNull("1", listener);
    		assertEquals("2", true, listener.isStarted());
			notify.sendMessage("Hello");
			assertEquals("3", true, listener.isCalled());
    	} finally {
    		_listenerContainer.stop();
    	}
    	try {
    		JMXService.removeNotificationListener(NotifyMBean.NAME, listener);
    		fail("4");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
	}

    protected void setUp() throws Exception {
    	super.setUp();    	
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(NotificationListenerContainerTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{NotificationListenerContainerTest.class.getName()});
    }
}