package org.seasar.nazuna;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class ResultType {

	private Class _resultClass;
	private List _tempPropertyTypeList = new ArrayList();
	private PropertyType[] _propertyTypes;
	private String[] _propertyNames;
	
	public ResultType(Class resultClass) {
		Assertion.assertNotNull("resultClass", resultClass);
		
		_resultClass = resultClass;
	}
	
	public Class getResultClass() {
		return _resultClass;
	}

	public void addPropertyType(PropertyType propertyType) {
		_tempPropertyTypeList.add(propertyType);
	}
	
	public void addPropertyTypeDone() {
		_propertyTypes = (PropertyType[]) _tempPropertyTypeList.toArray(
			new PropertyType[_tempPropertyTypeList.size()]);
		_tempPropertyTypeList.clear();
		_tempPropertyTypeList = null;
		_propertyNames = new String[_propertyTypes.length];
		for (int i = 0; i < _propertyTypes.length; ++i) {
			_propertyNames[i] = _propertyTypes[i].getName();
		}
	}
	
	public int getPropertyTypeSize() {
		return _propertyTypes.length;
	}
	
	public PropertyType getPropertyType(int index) {
		return _propertyTypes[index];
	}
	
	public List fetch(ResultSet rs) throws SeasarException {
		if (Map.class.isAssignableFrom(_resultClass)) {
			return fetchForMap(rs);
		} else {
			return fetchForBean(rs);
		}
	}
	
	public final String[] getPropertyNames() {
		return _propertyNames;
	}
	
	public List fetchForMap(ResultSet rs) throws SeasarException {
		List results = new ArrayList();
		try {
			while (rs.next()) {
				Map map = (Map) Reflector.newInstance(_resultClass);
				for (int i = 0; i < _propertyTypes.length; ++i) {
					_propertyTypes[i].fetchForMap(rs, map);
				}
				results.add(map);
			}
		} catch (SQLException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
		return results;
	}
	
	public List fetchForBean(ResultSet rs) throws SeasarException {
		List results = new ArrayList();
		try {
			while (rs.next()) {
				Object bean = Reflector.newInstance(_resultClass);
				for (int i = 0; i < _propertyTypes.length; ++i) {
					_propertyTypes[i].fetchForBean(rs, bean);
				}
				results.add(bean);
			}
		} catch (SQLException ex) {
			throw SeasarException.convertSeasarException(ex);
		}
		return results;
	}
}
