package org.seasar.mbean;

import java.util.ArrayList;
import java.util.List;

import org.seasar.log.Logger;
import org.seasar.system.Lifecycle;
import org.seasar.util.ElementHandler;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class MBeanService implements Lifecycle {

    private static final String XML_FILE_NAME = "/mbean-config.xml";
    private static final Logger _logger = Logger.getLogger(MBeanService.class);
    private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();
    private static List _containers = new ArrayList();
    
    static {
        configure();
    }

	public static Object getContainer(int index) {
		return _containers.get(index);
	}
    
    public void start() throws SeasarException {
        for (int i = 0; i < _containers.size(); i++) {
            try {
            	((Lifecycle) _containers.get(i)).start();
            } catch (Throwable t) {
                _logger.log(t);
            }
        }
    }
    
    public void stop() throws SeasarException {
        for (int i = _containers.size() - 1; i >= 0; i--) {
            try {
            	((Lifecycle) _containers.get(i)).stop();
            } catch (Throwable t) {
                _logger.log(t);
            }
        }
    }
    
    private static void configure() {
    	if (ResourceUtil.isExist(XML_FILE_NAME)) {
            setupXMLHandlerRule();
            XMLHandlerParser.parse(XML_FILE_NAME, _xmlHandlerRule);
        }
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/mbeanService/mbeans/mbean",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	try {
                    	String className = attributes.getValue("className");
                    	String name = attributes.getValue("name");
                    	MBeanContainer container = new MBeanContainer(className, name);
                    	_containers.add(container);
                    	xmlHandler.push(container);
                	} catch (Throwable t) {
                		_logger.log(t);
                		xmlHandler.push(t);
                	}
                }
                public void end(XMLHandler xmlHandler, String body) {
                    xmlHandler.pop();
                }
            });
    	_xmlHandlerRule.addElementHandler("/mbeanService/mbeans/mbean/properties/property",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	Object o = xmlHandler.peek();
                	if (o instanceof MBeanContainer) {
                		MBeanContainer container = (MBeanContainer) o;
                    	String name = attributes.getValue("name");
                    	String value = attributes.getValue("value");
                    	container.setProperty(name, value);
                	}
                }
            });

    	_xmlHandlerRule.addElementHandler("/mbeanService/notificationListeners/notificationListener",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	try {
                    	String className = attributes.getValue("className");
                    	String targetName = attributes.getValue("targetName");
                    	NotificationListenerContainer container =
                    		new NotificationListenerContainer(className, targetName);
                    	_containers.add(container);
                    	xmlHandler.push(container);
                	} catch (Throwable t) {
                		_logger.log(t);
                		xmlHandler.push(t);
                	}
                }
                public void end(XMLHandler xmlHandler, String body) {
                    xmlHandler.pop();
                }
            });
    	_xmlHandlerRule.addElementHandler("/mbeanService/notificationListeners/notificationListener/properties/property",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	Object o = xmlHandler.peek();
                	if (o instanceof NotificationListenerContainer) {
                		NotificationListenerContainer container = (NotificationListenerContainer) o;
                    	String name = attributes.getValue("name");
                    	String value = attributes.getValue("value");
                    	container.setProperty(name, value);
                	}
                }
            });

    	_xmlHandlerRule.addElementHandler("/mbeanService/remoteNotificationListeners/remoteNotificationListener",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	try {
                    	String className = attributes.getValue("className");
                    	String targetName = attributes.getValue("targetName");
                    	String seasarContextName = attributes.getValue("seasarContextName");
                    	RemoteNotificationListenerContainer container =
                    		new RemoteNotificationListenerContainer(
                    		className, targetName, seasarContextName);
                    	_containers.add(container);
                    	xmlHandler.push(container);
                	} catch (Throwable t) {
                		_logger.log(t);
                		xmlHandler.push(t);
                	}
                }
                public void end(XMLHandler xmlHandler, String body) {
                    xmlHandler.pop();
                }
            });
    	_xmlHandlerRule.addElementHandler("/mbeanService/remoteNotificationListeners/remoteNotificationListener/properties/property",
            new ElementHandler() {
                public void start(XMLHandler xmlHandler, Attributes attributes) {
                	Object o = xmlHandler.peek();
                	if (o instanceof RemoteNotificationListenerContainer) {
                		RemoteNotificationListenerContainer container = (RemoteNotificationListenerContainer) o;
                    	String name = attributes.getValue("name");
                    	String value = attributes.getValue("value");
                    	container.setProperty(name, value);
                	}
                }
            });
    }
}