package org.seasar.eclipse.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.seasar.eclipse.SeasarPlugin;

public class SeasarPreferencePage extends PreferencePage
		implements IWorkbenchPreferencePage {
			
	private DirectoryFieldEditor _homeEditor = null;

	public SeasarPreferencePage() {
		SeasarPlugin plugin = SeasarPlugin.getDefault();
		setPreferenceStore(plugin.getPreferenceStore());
	}

	public void init(IWorkbench workbench)  {
	}

	protected Control createContents(Composite parent)  {
		Composite composite = new Composite(parent, SWT.BORDER);
		RowLayout rowLayout = new RowLayout();
		rowLayout.justify = true;
		rowLayout.marginLeft = 5;
		rowLayout.marginRight = 5;
		rowLayout.spacing = 5;
		composite.setLayout(rowLayout);

		_homeEditor = new DirectoryFieldEditor("seasarHome", "Seasar Home", composite);
		_homeEditor.setStringValue(SeasarPlugin.getDefault().getSeasarHome());
		return composite;
	}
	
	protected void performDefaults() {
		_homeEditor.setStringValue(SeasarPlugin.getDefault().getDefaultSeasarHome());
	}

	public boolean performOk() {
		String seasarHome = _homeEditor.getStringValue(); 
		getPreferenceStore().setValue(
			SeasarPlugin.SEASAR_HOME_KEY, seasarHome);
		_homeEditor.store();
		SeasarPlugin.getDefault().savePluginPreferences();
		return true;
	}
}
