package org.seasar.eclipse;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class SeasarPlugin extends AbstractUIPlugin {

	public static final String SEASAR_HOME_KEY = "SEASAR_HOME";
	private static final String DEFAULT_SEASAR_HOME = "c:\\seasar";
	private static SeasarPlugin _plugin;
	private ResourceBundle _resourceBundle;

	public SeasarPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		_plugin = this;
		getPreferenceStore().setDefault(SEASAR_HOME_KEY, DEFAULT_SEASAR_HOME);
		try {
			_resourceBundle= ResourceBundle.getBundle("org.seasar.eclipse.SeasarPluginResources");
		} catch (MissingResourceException x) {
			_resourceBundle = null;
		}
	}

	public static SeasarPlugin getDefault() {
		return _plugin;
	}

	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	public static String getResourceString(String key) {
		ResourceBundle bundle= SeasarPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	public ResourceBundle getResourceBundle() {
		return _resourceBundle;
	}
	
	public String getSeasarHome() {
		return getPreferenceStore().getString(SEASAR_HOME_KEY);
	}
	
	public void setSeasarHome(String seasarHome) {
		getPreferenceStore().setValue(SEASAR_HOME_KEY, seasarHome);
	}
	
	public String getDefaultSeasarHome() {
		return getPreferenceStore().getDefaultString(SEASAR_HOME_KEY);
	}
}
