package test.org.seasar.mbean;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.mbean.RemoteNotificationListenerContainer;
import org.seasar.system.JMXService;
import org.seasar.util.SeasarException;

import test.org.seasar.system.NotificationListenerTester;
import test.org.seasar.system.Notify;
import test.org.seasar.system.NotifyMBean;
import test.org.seasar.system.RMIAdaptorTestCase;

public class RemoteNotificationListenerContainerTest extends RMIAdaptorTestCase {

	private RemoteNotificationListenerContainer _listenerContainer;
	
    public RemoteNotificationListenerContainerTest(String name) throws Exception {
        super(name);
    }

	public void testStartAndStop() throws Exception {
		Notify notify = new Notify();
		JMXService.registerMBean(notify, NotifyMBean.NAME);
		
		_listenerContainer = new RemoteNotificationListenerContainer(
			NotificationListenerTester.class.getName(), "Notify", "default");
		NotificationListenerTester listener = null;
    	_listenerContainer.start();
    	String listenerName = _listenerContainer.getRMINotificationListenerAdaptor().getListenerName();
    	try {
   			listener = (NotificationListenerTester)
    			_listenerContainer.getNotificationListener();
    		assertNotNull("1", listener);
    		assertEquals("2", true, listener.isStarted());
			notify.sendMessage("Hello");
			assertEquals("3", true, listener.isCalled());
    	} finally {
    		_listenerContainer.stop();
    	}
    	assertEquals("4", false, JMXService.isRegistered(listenerName));
    	try {
    		JMXService.removeNotificationListener(NotifyMBean.NAME, listenerName);
    		fail("5");
    	} catch (SeasarException ex) {
    		System.out.println(ex);
    	}
	}

    protected void setUp() throws Exception {
    	super.setUp();    	
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(RemoteNotificationListenerContainerTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{RemoteNotificationListenerContainerTest.class.getName()});
    }
}