package org.seasar.nazuna;

import java.io.File;

import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;

public final class SqletDeployer {

	private File _file;
	private long _lastModified = 0;
	private Sqlet _sqlet;
	
	public SqletDeployer(String name) {
		_file = ResourceUtil.getFile(name, "xml");
	}
	
	public final File getFile() {
		return _file;
	}
	
	public final long getLastModified() {
		return _lastModified;
	}
	
	public final Sqlet getSqlet() {
		return _sqlet;
	}

	public final synchronized void deploy() throws SeasarException {
		if (_file.lastModified() != _lastModified) {
        	_sqlet = SqletBuilder.parse(_file);
            _lastModified = _file.lastModified();
        }    
    }
}
