/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.scope.ApplicationScope;
import org.seasar.maya.impl.ParameterAwareImpl;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.source.ForbiddenPathException;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public class ApplicationSourceDescriptor
extends ParameterAwareImpl
implements SourceDescriptor {
    private static final long serialVersionUID = -2775274363708858237L;
    public static final String WEB_INF = "/WEB-INF";
    private String _root = "";
    private File _file;
    private ApplicationScope _application;
    private boolean _denyWebInf = true;

    public void setApplicationScope(ApplicationScope application) {
        if (application == null) {
            throw new IllegalArgumentException();
        }
        this._application = application;
    }

    public ApplicationScope getApplicationScope() {
        if (this._application == null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            this._application = cycle.getApplicationScope();
        }
        return this._application;
    }

    public void setDenyWebInf(boolean denyWebInf) {
        this._denyWebInf = denyWebInf;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public File getFile() {
        this.exists();
        return this._file;
    }

    public void setRoot(String root) {
        this._root = StringUtil.preparePath(root);
    }

    public String getRoot() {
        return this._root;
    }

    public void setSystemID(String systemID) {
        if (this._denyWebInf && systemID != null && systemID.indexOf(WEB_INF) != -1) {
            throw new ForbiddenPathException(systemID);
        }
        super.setSystemID(StringUtil.preparePath(systemID));
    }

    public boolean exists() {
        File file;
        String realPath;
        if (this._file == null && StringUtil.hasValue(realPath = this.getApplicationScope().getRealPath(String.valueOf(this._root) + this.getSystemID())) && (file = new File(realPath)).exists()) {
            this._file = file;
        }
        return this._file != null && this._file.exists();
    }

    public InputStream getInputStream() {
        if (this.exists() && this._file.isFile()) {
            try {
                return new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Date getTimestamp() {
        if (this.exists()) {
            return new Date(this._file.lastModified());
        }
        return new Date(0L);
    }
}

