/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification.xpath;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.PatternParser;
import org.jaxen.saxpath.SAXPathException;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.engine.specification.xpath.NamespaceContextImpl;
import org.seasar.maya.impl.engine.specification.xpath.SpecificationNavigator;
import org.seasar.maya.impl.engine.specification.xpath.SpecificationXPath;
import org.seasar.maya.impl.util.StringUtil;

public class XPathUtil {
    private XPathUtil() {
    }

    public static boolean matches(SpecificationNode test, String xpathExpr, Namespace namespace) {
        if (StringUtil.isEmpty(xpathExpr)) {
            throw new IllegalArgumentException();
        }
        Object nsContext = namespace == null ? new SimpleNamespaceContext() : new NamespaceContextImpl(namespace);
        ContextSupport support = new ContextSupport((NamespaceContext)nsContext, XPathFunctionContext.getInstance(), (VariableContext)new SimpleVariableContext(), SpecificationNavigator.getInstance());
        Context context = new Context(support);
        try {
            Pattern pattern = PatternParser.parse((String)xpathExpr);
            return pattern.matches((Object)test, context);
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        catch (SAXPathException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterator selectChildNodes(SpecificationNode node, String xpathExpr, Namespace namespaceable, boolean cascade) {
        Specification specification = SpecificationUtil.findSpecification(node);
        if (StringUtil.isEmpty(xpathExpr)) {
            throw new IllegalArgumentException();
        }
        if (cascade) {
            return new CascadeSelectNodesIterator(specification, xpathExpr, namespaceable);
        }
        try {
            XPath xpath = SpecificationXPath.createXPath(xpathExpr, namespaceable);
            return xpath.selectNodes((Object)specification).iterator();
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CascadeSelectNodesIterator
    implements Iterator {
        private Specification _specification;
        private String _xpathExpr;
        private Namespace _namespaceable;
        private Iterator _iterator;

        public CascadeSelectNodesIterator(Specification specification, String xpathExpr, Namespace namespaceable) {
            if (specification == null || StringUtil.isEmpty(xpathExpr)) {
                throw new IllegalArgumentException();
            }
            this._specification = specification;
            this._xpathExpr = xpathExpr;
            this._namespaceable = namespaceable;
        }

        public boolean hasNext() {
            while (true) {
                if (this._iterator == null) {
                    XPath xpath = SpecificationXPath.createXPath(this._xpathExpr, this._namespaceable);
                    try {
                        this._iterator = xpath.selectNodes((Object)this._specification).iterator();
                    }
                    catch (JaxenException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this._iterator.hasNext()) {
                    return true;
                }
                Specification parent = EngineUtil.getParentSpecification(this._specification);
                if (parent == null) {
                    return false;
                }
                this._specification = parent;
                this._iterator = null;
            }
        }

        public Object next() {
            if (this.hasNext()) {
                return this._iterator.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

