/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.specification;

import java.util.Iterator;
import java.util.Map;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.specification.Namespace;
import org.seasar.maya.engine.specification.NodeAttribute;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.engine.specification.QName;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.engine.specification.SpecificationNode;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.cycle.script.ScriptUtil;
import org.seasar.maya.impl.engine.specification.IllegalChildNodeException;
import org.seasar.maya.impl.engine.specification.NamespaceImpl;
import org.seasar.maya.impl.engine.specification.PrefixAwareNameImpl;
import org.seasar.maya.impl.engine.specification.QNameImpl;
import org.seasar.maya.impl.engine.specification.SpecificationNodeImpl;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;

public class SpecificationUtil
implements CONST_IMPL {
    static /* synthetic */ Class class$0;

    private SpecificationUtil() {
    }

    public static String getAttributeValue(SpecificationNode node, QName qName) {
        NodeAttribute nameAttr = node.getAttribute(qName);
        if (nameAttr != null) {
            return nameAttr.getValue();
        }
        return null;
    }

    public static Specification findSpecification(NodeTreeWalker current) {
        while (!(current instanceof Specification)) {
            if ((current = current.getParentNode()) != null) continue;
            return null;
        }
        return (Specification)current;
    }

    public static Specification findSpecification() {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        NodeTreeWalker current = cycle.getOriginalNode();
        return SpecificationUtil.findSpecification(current);
    }

    public static SpecificationNode getMayaNode(NodeTreeWalker current) {
        Specification specification = SpecificationUtil.findSpecification(current);
        Iterator it = specification.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode node = (SpecificationNode)it.next();
            if (!node.getQName().equals(QM_MAYA)) continue;
            return node;
        }
        return null;
    }

    public static String getMayaAttributeValue(NodeTreeWalker current, QName qName) {
        String value;
        SpecificationNode maya = SpecificationUtil.getMayaNode(current);
        if (maya != null && (value = SpecificationUtil.getAttributeValue(maya, qName)) != null) {
            return value;
        }
        return null;
    }

    public static String getNodeBodyText(SpecificationNode node) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = node.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode child = (SpecificationNode)it.next();
            QName qName = child.getQName();
            if (QM_CDATA.equals(qName)) {
                buffer.append(SpecificationUtil.getNodeBodyText(child));
                continue;
            }
            if (QM_CHARACTERS.equals(qName)) {
                buffer.append(SpecificationUtil.getAttributeValue(child, QM_TEXT));
                continue;
            }
            String name = String.valueOf(child.getPrefix()) + ":" + qName.getLocalName();
            throw new IllegalChildNodeException(name);
        }
        return buffer.toString();
    }

    public static void initScope() {
        ProviderUtil.getScriptEnvironment().initScope();
    }

    public static void startScope(Map variables) {
        ProviderUtil.getScriptEnvironment().startScope(variables);
    }

    public static void endScope() {
        ProviderUtil.getScriptEnvironment().endScope();
    }

    public static void execEventScript(String text) {
        if (StringUtil.hasValue(text)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Void");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CompiledScript script = ScriptUtil.compile(text, clazz);
            script.execute(null);
        }
    }

    public static void execEvent(Specification spec, QName eventName) {
        if (eventName == null) {
            throw new IllegalArgumentException();
        }
        SpecificationNode maya = SpecificationUtil.getMayaNode(spec);
        if (maya != null) {
            Iterator it = maya.iterateChildNode();
            while (it.hasNext()) {
                SpecificationNode child = (SpecificationNode)it.next();
                if (!eventName.equals(child.getQName())) continue;
                String bodyText = SpecificationUtil.getNodeBodyText(child);
                bodyText = ScriptUtil.getBlockSignedText(bodyText);
                SpecificationUtil.execEventScript(bodyText);
            }
            NodeAttribute attr = maya.getAttribute(eventName);
            if (attr != null) {
                String attrText = attr.getValue();
                SpecificationUtil.execEventScript(attrText);
            }
        }
    }

    public static Namespace createNamespace() {
        return new NamespaceImpl();
    }

    public static QName createQName(String localName) {
        return SpecificationUtil.createQName("http://maya.seasar.org", localName);
    }

    public static QName createQName(String namespaceURI, String localName) {
        return new QNameImpl(namespaceURI, localName);
    }

    public static PrefixAwareName createPrefixAwareName(QName qName) {
        return new PrefixAwareNameImpl(qName);
    }

    public static SpecificationNode createSpecificationNode(QName qName, String systemID, int lineNumber, boolean onTemplate, int sequenceID) {
        SpecificationNodeImpl node = new SpecificationNodeImpl(qName);
        node.setSequenceID(sequenceID);
        node.setSystemID(systemID);
        node.setLineNumber(lineNumber);
        node.setOnTemplate(onTemplate);
        return node;
    }
}

