/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.maya.cycle.CycleWriter;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.processor.ChildEvaluationProcessor;
import org.seasar.maya.engine.processor.InformalPropertyAcceptable;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorProperty;
import org.seasar.maya.engine.specification.PrefixAwareName;
import org.seasar.maya.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.maya.impl.util.collection.NullIterator;

public abstract class AbstractAttributableProcessor
extends TemplateProcessorSupport
implements ChildEvaluationProcessor,
InformalPropertyAcceptable {
    private boolean _childEvaluation;
    private List _attributes;
    private ThreadLocal _processtimeInfo = new ThreadLocal();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void clearProcesstimeInfo() {
        this._processtimeInfo.set(null);
    }

    protected ProcesstimeInfo getProcesstimeInfo() {
        ProcesstimeInfo info = (ProcesstimeInfo)this._processtimeInfo.get();
        if (info == null) {
            info = new ProcesstimeInfo();
            this._processtimeInfo.set(info);
        }
        return info;
    }

    public void setChildEvaluation(boolean childEvaluation) {
        this._childEvaluation = childEvaluation;
    }

    public void addInformalProperty(PrefixAwareName name, Object attr) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(attr);
    }

    public Class getPropertyClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.maya.engine.processor.ProcessorProperty");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getExpectedClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Iterator iterateInformalProperties() {
        if (this._attributes == null) {
            return NullIterator.getInstance();
        }
        return this._attributes.iterator();
    }

    public void addProcesstimeProperty(ProcessorProperty prop) {
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        ProcesstimeInfo info = this.getProcesstimeInfo();
        info.addProcesstimeProperty(prop);
    }

    public boolean hasProcesstimeProperty(ProcessorProperty prop) {
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        ProcesstimeInfo info = this.getProcesstimeInfo();
        return info.hasProcesstimeProperty(prop);
    }

    public Iterator iterateProcesstimeProperties() {
        ProcesstimeInfo info = this.getProcesstimeInfo();
        return info.iterateProcesstimeProperties();
    }

    protected abstract ProcessStatus writeStartElement();

    protected abstract void writeEndElement();

    public ProcessStatus doStartProcess(Page topLevelPage) {
        this.clearProcesstimeInfo();
        if (this._childEvaluation) {
            return ProcessStatus.EVAL_BODY_BUFFERED;
        }
        return this.writeStartElement();
    }

    public boolean isChildEvaluation() {
        return this._childEvaluation;
    }

    public void setBodyContent(CycleWriter body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        ProcesstimeInfo info = this.getProcesstimeInfo();
        info.setBody(body);
    }

    public void doInitChildProcess() {
    }

    public boolean isIteration() {
        return false;
    }

    public ProcessStatus doAfterChildProcess() {
        return ProcessStatus.SKIP_BODY;
    }

    public ProcessStatus doEndProcess() {
        ProcesstimeInfo info = this.getProcesstimeInfo();
        if (this._childEvaluation) {
            this.writeStartElement();
            CycleWriter body = info.getBody();
            if (body != null) {
                try {
                    body.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.writeEndElement();
        return ProcessStatus.EVAL_PAGE;
    }

    protected class ProcesstimeInfo {
        private CycleWriter _body;
        private List _processtimeProperties;

        protected ProcesstimeInfo() {
        }

        public void setBody(CycleWriter body) {
            if (body == null) {
                throw new IllegalArgumentException();
            }
            this._body = body;
        }

        public CycleWriter getBody() {
            return this._body;
        }

        public boolean hasProcesstimeProperty(ProcessorProperty property) {
            if (property == null) {
                throw new IllegalArgumentException();
            }
            if (this._processtimeProperties == null) {
                return false;
            }
            return this._processtimeProperties.contains(property);
        }

        public void addProcesstimeProperty(ProcessorProperty property) {
            if (property == null) {
                throw new IllegalArgumentException();
            }
            if (this._processtimeProperties == null) {
                this._processtimeProperties = new ArrayList();
            }
            if (!this._processtimeProperties.contains(property)) {
                this._processtimeProperties.add(property);
            }
        }

        public Iterator iterateProcesstimeProperties() {
            if (this._processtimeProperties == null) {
                return NullIterator.getInstance();
            }
            return this._processtimeProperties.iterator();
        }
    }
}

