/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine;

import java.util.LinkedList;
import java.util.Map;
import org.seasar.maya.cycle.ServiceCycle;
import org.seasar.maya.cycle.script.CompiledScript;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.TemplateRenderer;
import org.seasar.maya.engine.processor.ChildEvaluationProcessor;
import org.seasar.maya.engine.processor.IterationProcessor;
import org.seasar.maya.engine.processor.ProcessStatus;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.processor.TemplateProcessor;
import org.seasar.maya.engine.processor.TryCatchFinallyProcessor;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.cycle.CycleUtil;
import org.seasar.maya.impl.engine.PageNotFoundException;
import org.seasar.maya.impl.engine.processor.ElementProcessor;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.source.SourceDescriptor;

public class RenderUtil
implements CONST_IMPL {
    private static final ProcessStatus SKIP_BODY = ProcessStatus.SKIP_BODY;
    private static final ProcessStatus EVAL_BODY_INCLUDE = ProcessStatus.EVAL_BODY_INCLUDE;
    private static final ProcessStatus SKIP_PAGE = ProcessStatus.SKIP_PAGE;
    private static final ProcessStatus EVAL_PAGE = ProcessStatus.EVAL_PAGE;
    private static final ProcessStatus EVAL_BODY_AGAIN = ProcessStatus.EVAL_BODY_AGAIN;
    private static final ProcessStatus EVAL_BODY_BUFFERED = ProcessStatus.EVAL_BODY_BUFFERED;

    private RenderUtil() {
    }

    public static boolean isEvaluation(TemplateProcessor current) {
        return current instanceof ChildEvaluationProcessor && ((ChildEvaluationProcessor)current).isChildEvaluation();
    }

    public static ChildEvaluationProcessor getEvaluation(TemplateProcessor current) {
        return (ChildEvaluationProcessor)current;
    }

    public static boolean isIteration(TemplateProcessor current) {
        return current instanceof IterationProcessor && ((IterationProcessor)current).isIteration();
    }

    public static IterationProcessor getIteration(TemplateProcessor current) {
        return (IterationProcessor)current;
    }

    public static boolean isDuplicated(TemplateProcessor current) {
        return current instanceof ElementProcessor && ((ElementProcessor)current).isDuplicated();
    }

    public static boolean isTryCatchFinally(TemplateProcessor current) {
        if (current instanceof TryCatchFinallyProcessor) {
            TryCatchFinallyProcessor tryCatchFinallyProcessor = (TryCatchFinallyProcessor)current;
            return tryCatchFinallyProcessor.canCatch();
        }
        return false;
    }

    public static TryCatchFinallyProcessor getTryCatchFinally(TemplateProcessor current) {
        return (TryCatchFinallyProcessor)current;
    }

    public static void saveToCycle(ProcessorTreeWalker current) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setProcessor(current);
        if (current instanceof TemplateProcessor) {
            TemplateProcessor proc = (TemplateProcessor)current;
            cycle.setOriginalNode(proc.getOriginalNode());
            cycle.setInjectedNode(proc.getInjectedNode());
        } else if (current instanceof Template) {
            Template temp = (Template)current;
            cycle.setOriginalNode(temp);
            cycle.setInjectedNode(temp);
        }
    }

    /*
     * Exception decompiling
     */
    public static ProcessStatus renderTemplateProcessor(Page topLevelPage, TemplateProcessor current) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 405->408)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ProcessStatus renderProcessorTree(Page topLevelPage, ProcessorTreeWalker root) {
        int i = 0;
        while (i < root.getChildProcessorSize()) {
            ProcessorTreeWalker child = root.getChildProcessor(i);
            if (child instanceof TemplateProcessor) {
                TemplateProcessor childProc = (TemplateProcessor)child;
                ProcessStatus childRet = RenderUtil.renderTemplateProcessor(topLevelPage, childProc);
                if (childRet == SKIP_PAGE) {
                    return SKIP_PAGE;
                }
            } else {
                throw new IllegalStateException();
            }
            ++i;
        }
        return EVAL_PAGE;
    }

    public static void saveToCycle(Page page) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(page);
        cycle.setInjectedNode(page);
    }

    protected static Template getTemplate(String requestedSuffix, Page page, String suffix, String extension) {
        SourceDescriptor source;
        boolean maya = "maya".equals(extension);
        if (maya && !(source = page.getSource()).exists()) {
            String pageName = page.getPageName();
            throw new PageNotFoundException(pageName, extension);
        }
        if (!maya) {
            if (StringUtil.isEmpty(suffix)) {
                if (StringUtil.isEmpty(requestedSuffix)) {
                    CompiledScript script = page.getSuffixScript();
                    suffix = (String)script.execute(null);
                } else {
                    suffix = requestedSuffix;
                }
            }
            return page.getTemplate(suffix, extension);
        }
        return null;
    }

    public static ProcessStatus renderPage(boolean fireEvent, TemplateRenderer renderer, Map variables, Page topLevelPage, String requestedSuffix, String extension) {
        if (renderer == null || topLevelPage == null) {
            throw new IllegalArgumentException();
        }
        Page page = topLevelPage;
        String suffix = null;
        RenderUtil.saveToCycle(page);
        LinkedList<Page> pageStack = fireEvent ? new LinkedList<Page>() : null;
        LinkedList<Template> templateStack = new LinkedList<Template>();
        do {
            Template template;
            if (fireEvent) {
                pageStack.add(0, page);
                SpecificationUtil.startScope(variables);
                SpecificationUtil.execEvent(page, QM_BEFORE_RENDER);
            }
            if ((template = RenderUtil.getTemplate(requestedSuffix, page, suffix, extension)) != null) {
                templateStack.add(0, template);
            }
            suffix = page.getSuperSuffix();
            extension = page.getSuperExtension();
            page = page.getSuperPage();
            variables = null;
        } while (page != null);
        ProcessStatus ret = null;
        int templateSize = templateStack.size();
        if (templateSize > 0) {
            Template[] templates = templateStack.toArray(new Template[templateSize]);
            ret = renderer.renderTemplate(topLevelPage, templates);
            RenderUtil.saveToCycle(page);
        }
        if (fireEvent) {
            int i = 0;
            while (i < pageStack.size()) {
                page = (Page)pageStack.get(i);
                RenderUtil.saveToCycle(page);
                SpecificationUtil.execEvent(page, QM_AFTER_RENDER);
                SpecificationUtil.endScope();
                ++i;
            }
        }
        return ret;
    }
}

