/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.engine;

import org.seasar.maya.engine.Engine;
import org.seasar.maya.engine.Page;
import org.seasar.maya.engine.Template;
import org.seasar.maya.engine.processor.ProcessorTreeWalker;
import org.seasar.maya.engine.specification.NodeTreeWalker;
import org.seasar.maya.engine.specification.Specification;
import org.seasar.maya.impl.CONST_IMPL;
import org.seasar.maya.impl.engine.specification.SpecificationUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.ObjectUtil;

public class EngineUtil
implements CONST_IMPL {
    private EngineUtil() {
    }

    public static String getEngineSetting(String name, String defaultValue) {
        Engine engine = ProviderUtil.getEngine();
        String value = engine.getParameter(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getEngineSettingBoolean(String name, boolean defaultValue) {
        Engine engine = ProviderUtil.getEngine();
        String value = engine.getParameter(name);
        return ObjectUtil.booleanValue(value, defaultValue);
    }

    public static Template getTemplate() {
        Specification spec = SpecificationUtil.findSpecification();
        if (spec instanceof Page) {
            NodeTreeWalker parent = spec.getParentNode();
            if (parent != null) {
                spec = SpecificationUtil.findSpecification();
            } else {
                return null;
            }
        }
        if (spec instanceof Template) {
            return (Template)spec;
        }
        throw new IllegalStateException();
    }

    public static Template getTemplate(ProcessorTreeWalker proc) {
        ProcessorTreeWalker current = proc;
        while (current != null) {
            if (current instanceof Template) {
                return (Template)current;
            }
            current = current.getParentProcessor();
        }
        throw new IllegalStateException();
    }

    public static Specification getParentSpecification(Specification spec) {
        if (spec instanceof Page) {
            return ProviderUtil.getEngine();
        }
        if (spec instanceof Template) {
            return ((Template)spec).getPage();
        }
        return null;
    }
}

