/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.maya.impl.cycle.web;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.seasar.maya.cycle.scope.AttributeScope;
import org.seasar.maya.cycle.script.ScriptEnvironment;
import org.seasar.maya.impl.cycle.scope.AbstractRequestScope;
import org.seasar.maya.impl.cycle.web.HeaderValuesScope;
import org.seasar.maya.impl.cycle.web.ParamValuesScope;
import org.seasar.maya.impl.engine.EngineUtil;
import org.seasar.maya.impl.provider.ProviderUtil;
import org.seasar.maya.impl.util.StringUtil;
import org.seasar.maya.impl.util.collection.EnumerationIterator;

public class RequestScopeImpl
extends AbstractRequestScope {
    private static final long serialVersionUID = 8377365781441987529L;
    private HttpServletRequest _httpServletRequest;
    private Locale[] _locales;
    private ParamValuesScope _paramValues;
    private HeaderValuesScope _headerValues;

    protected void check() {
        if (this._httpServletRequest == null) {
            throw new IllegalStateException();
        }
    }

    public String getContextPath() {
        this.check();
        return StringUtil.preparePath(this._httpServletRequest.getContextPath());
    }

    public String getRequestedPath() {
        this.check();
        String path = this._httpServletRequest.getPathInfo();
        if (path == null) {
            path = this._httpServletRequest.getServletPath();
        }
        if (StringUtil.isEmpty(path) || path.endsWith("/")) {
            String welcome = EngineUtil.getEngineSetting("welcomeFileName", "/index.html");
            path = String.valueOf(StringUtil.preparePath(path)) + StringUtil.preparePath(welcome);
        }
        return path;
    }

    public Locale[] getLocales() {
        this.check();
        if (this._locales == null) {
            Enumeration locales = this._httpServletRequest.getLocales();
            if (locales == null) {
                this._locales = new Locale[0];
            } else {
                ArrayList list = new ArrayList();
                while (locales.hasMoreElements()) {
                    list.add(locales.nextElement());
                }
                this._locales = list.toArray(new Locale[list.size()]);
            }
        }
        return this._locales;
    }

    public AttributeScope getParamValues() {
        this.check();
        if (this._paramValues == null) {
            this._paramValues = new ParamValuesScope(this._httpServletRequest);
        }
        return this._paramValues;
    }

    public AttributeScope getHeaderValues() {
        this.check();
        if (this._headerValues == null) {
            this._headerValues = new HeaderValuesScope(this._httpServletRequest);
        }
        return this._headerValues;
    }

    public Iterator iterateAttributeNames() {
        this.check();
        return EnumerationIterator.getInstance(this._httpServletRequest.getAttributeNames());
    }

    public boolean hasAttribute(String name) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        Enumeration e = this._httpServletRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        ScriptEnvironment env = ProviderUtil.getScriptEnvironment();
        return env.convertFromScriptObject(this._httpServletRequest.getAttribute(name));
    }

    public void setAttribute(String name, Object attribute) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._httpServletRequest.setAttribute(name, attribute);
    }

    public void removeAttribute(String name) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._httpServletRequest.removeAttribute(name);
    }

    public void setUnderlyingContext(Object context) {
        if (context == null || !(context instanceof HttpServletRequest)) {
            throw new IllegalArgumentException();
        }
        this._httpServletRequest = (HttpServletRequest)context;
        this._locales = null;
        this._paramValues = null;
        this._headerValues = null;
        this.parsePath(this.getRequestedPath());
    }

    public Object getUnderlyingContext() {
        this.check();
        return this._httpServletRequest;
    }
}

